<?php
/*
Plugin Name: TaskMaster Pro
Description: افزونه حرفه‌ای مدیریت وظایف و پروژه‌ها برای وردپرس
Version: 1.0.0
Author: Your Name
Text Domain: taskmaster-pro
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// بارگذاری فایل‌های مورد نیاز
require_once plugin_dir_path(__FILE__) . 'includes/class-taskmaster-db.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-taskmaster-admin.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-taskmaster-frontend.php';
require_once plugin_dir_path(__FILE__) . 'includes/functions.php';

// فعال‌سازی افزونه
register_activation_hook(__FILE__, ['TaskMaster_DB', 'install']);

// افزودن منو به پیشخوان
add_action('admin_menu', ['TaskMaster_Admin', 'add_admin_menu']);

// بارگذاری اسکریپت‌ها و استایل‌ها
add_action('admin_enqueue_scripts', ['TaskMaster_Admin', 'enqueue_assets']);
add_action('wp_enqueue_scripts', ['TaskMaster_Frontend', 'enqueue_assets']);

// شورت‌کد برای نمایش در سایت
add_shortcode('taskmaster', ['TaskMaster_Frontend', 'render']); 