// اسکریپت بهینه‌شده ادمین TaskMaster Pro
jQuery(document).ready(function($){
    'use strict';
    
    // کش کردن عناصر پرکاربرد
    const $body = $('body');
    const $notices = $('.notice');
    
    // بهبود عملکرد فرم‌ها
    $('form').on('submit', function(e) {
        const $form = $(this);
        const $submitBtn = $form.find('button[type="submit"]');
        
        // جلوگیری از ارسال چندباره
        if ($submitBtn.hasClass('submitting')) {
            e.preventDefault();
            return false;
        }
        
        // نمایش وضعیت بارگذاری
        $submitBtn.addClass('submitting').text(taskmaster_ajax.strings.loading);
        
        // بررسی فیلدهای ضروری
        const requiredFields = $form.find('[required]');
        let isValid = true;
        
        requiredFields.each(function() {
            if (!$(this).val().trim()) {
                isValid = false;
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            $submitBtn.removeClass('submitting').text('ثبت');
            alert('لطفاً تمام فیلدهای ضروری را پر کنید.');
            return false;
        }
    });
    
    // بهبود عملکرد دکمه‌های حذف
    $('.button-link-delete').on('click', function(e) {
        if (!confirm(taskmaster_ajax.strings.confirm_delete)) {
            e.preventDefault();
            return false;
        }
        
        const $link = $(this);
        $link.addClass('deleting').text(taskmaster_ajax.strings.loading);
    });
    
    // بهبود عملکرد جستجو
    let searchTimeout;
    $('input[name="project_search"], input[name="task_search"]').on('input', function() {
        clearTimeout(searchTimeout);
        const $input = $(this);
        const $form = $input.closest('form');
        
        searchTimeout = setTimeout(function() {
            $form.submit();
        }, 500); // تاخیر 500 میلی‌ثانیه
    });
    
    // بهبود نمایش پیام‌ها
    $notices.on('click', '.notice-dismiss', function() {
        $(this).closest('.notice').fadeOut();
    });
    
    // بهبود عملکرد جدول‌ها
    $('.widefat').each(function() {
        const $table = $(this);
        const $rows = $table.find('tbody tr');
        
        if ($rows.length > 10) {
            // اضافه کردن pagination برای جداول بزرگ
            const itemsPerPage = 10;
            const totalPages = Math.ceil($rows.length / itemsPerPage);
            
            if (totalPages > 1) {
                $table.after('<div class="tablenav-pages"><span class="pagination-links"></span></div>');
                const $pagination = $table.next('.tablenav-pages').find('.pagination-links');
                
                for (let i = 1; i <= totalPages; i++) {
                    $pagination.append('<a href="#" class="page-numbers" data-page="' + i + '">' + i + '</a>');
                }
                
                // نمایش صفحه اول
                showPage(1);
                
                // رویداد کلیک pagination
                $pagination.on('click', '.page-numbers', function(e) {
                    e.preventDefault();
                    const page = parseInt($(this).data('page'));
                    showPage(page);
                });
                
                function showPage(page) {
                    $rows.hide();
                    const start = (page - 1) * itemsPerPage;
                    const end = start + itemsPerPage;
                    $rows.slice(start, end).show();
                    
                    $pagination.find('.page-numbers').removeClass('current');
                    $pagination.find('[data-page="' + page + '"]').addClass('current');
                }
            }
        }
    });
    
    // بهبود عملکرد فیلترها
    $('select[name="project_status"], select[name="task_status"], select[name="task_priority"]').on('change', function() {
        $(this).closest('form').submit();
    });
    
    // بهبود عملکرد تقویم
    if ($('#taskmaster-calendar').length) {
        // اضافه کردن رویدادهای تقویم
        $('#taskmaster-calendar td').on('click', function() {
            const date = $(this).data('date');
            if (date) {
                // نمایش تسک‌های روز انتخاب شده
                showTasksForDate(date);
            }
        });
    }
    
    // تابع نمایش تسک‌های روز
    function showTasksForDate(date) {
        // اینجا می‌توان AJAX call اضافه کرد
        console.log('نمایش تسک‌های تاریخ:', date);
    }
    
    // بهبود عملکرد گزارش‌گیری
    $('.report-filter select, .report-filter input[type="date"]').on('change', function() {
        const $form = $(this).closest('form');
        if ($form.length) {
            $form.submit();
        }
    });
    
    // بهبود عملکرد دکمه‌های عملیات
    $('.button-small').on('click', function() {
        const $btn = $(this);
        if (!$btn.hasClass('submitting')) {
            $btn.addClass('submitting');
            setTimeout(() => {
                $btn.removeClass('submitting');
            }, 1000);
        }
    });
    
    // بهبود عملکرد فرم‌های ویرایش
    $('form').on('reset', function() {
        $(this).find('.error').removeClass('error');
        $(this).find('button[type="submit"]').removeClass('submitting').text('ثبت');
    });
    
    // بهبود عملکرد نمایش/مخفی کردن بخش‌ها
    $('.toggle-section').on('click', function(e) {
        e.preventDefault();
        const target = $(this).data('target');
        $('#' + target).slideToggle();
        $(this).toggleClass('active');
    });
    
    // بهبود عملکرد validation
    $('input[required], textarea[required]').on('blur', function() {
        const $field = $(this);
        if (!$field.val().trim()) {
            $field.addClass('error');
        } else {
            $field.removeClass('error');
        }
    });
    
    // بهبود عملکرد loading states
    $(document).on('submit', 'form', function() {
        const $form = $(this);
        const $submitBtn = $form.find('button[type="submit"]');
        
        if ($submitBtn.length && !$submitBtn.hasClass('submitting')) {
            $submitBtn.addClass('submitting').text(taskmaster_ajax.strings.loading);
        }
    });
    
    // بهبود عملکرد error handling
    $(document).ajaxError(function(event, xhr, settings, error) {
        console.error('AJAX Error:', error);
        alert(taskmaster_ajax.strings.error);
    });
    
    // بهبود عملکرد responsive design
    function handleResponsive() {
        if ($(window).width() < 768) {
            $('.widefat').addClass('mobile-table');
        } else {
            $('.widefat').removeClass('mobile-table');
        }
    }
    
    $(window).on('resize', handleResponsive);
    handleResponsive();
}); 